@echo off
setlocal

REM Thanks to Capcom for the amazing games.
REM Thanks to FluffyQuack for the great ArcTool.
REM Thanks to Hikari for figuring this out so quickly.
REM Thanks to the community for being awesome.

title Capcom Collection Tool v1.12

for /f "tokens=2* skip=1" %%a in ('reg query "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Steam App 1685750" /v InstallLocation 2^>NUL') do set CFCBasePath=%%b
REM ... this path might be wrong for 32bit systems...
set CFCPath=%CFCBasePath%\nativeDX11x64\arc\pc

REM OK, we have where it SHOULD be, but you know sometimes systems get in weird states so let's check alt paths if we couldn't find it
if not exist "%CFCPath%\game_50.arc" if exist "%ProgramFiles(x86)%\Steam\steamapps\common\CAPCOM FIGHTING COLLECTION\nativeDX11x64\arc\pc\game_50.arc" set CFCPath=%ProgramFiles(x86)%\Steam\steamapps\common\CAPCOM FIGHTING COLLECTION\nativeDX11x64\arc\pc
if not exist "%CFCPath%\game_50.arc" if exist "%ProgramFiles%\Steam\steamapps\common\CAPCOM FIGHTING COLLECTION\nativeDX11x64\arc\pc\game_50.arc" set CFCPath=%ProgramFiles%\Steam\steamapps\common\CAPCOM FIGHTING COLLECTION\nativeDX11x64\arc\pc
REM this dp0 / instance path should be %wherever%\mvcc\nat\arc\pc\ARCTOOL
REM note we deliberately aren't just doing ".." because who knows where the heck we actually are.
if not exist "%CFCPath%\game_50.arc" if exist "%~dp0..\..\..\..\..\CAPCOM FIGHTING COLLECTION\nativeDX11x64\arc\pc\game_50.arc" set CFCPath=%~dp0..\..\..\..\..\CAPCOM FIGHTING COLLECTION\nativeDX11x64\arc\pc

for /f "tokens=2* skip=1" %%a in ('reg query "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Steam App 2634890" /v InstallLocation 2^>NUL') do set MVCBasePath=%%b
set MVCPath=%MVCBasePath%\nativeDX11x64\arc\pc

if not exist "%MVCPath%\game_50.arc" if exist "%ProgramFiles(x86)%\Steam\steamapps\common\MARVEL vs. CAPCOM Fighting Collection\nativeDX11x64\arc\pc\game_50.arc" set MVCPath=%ProgramFiles(x86)%\Steam\steamapps\common\MARVEL vs. CAPCOM Fighting Collection\nativeDX11x64\arc\pc
if not exist "%MVCPath%\game_50.arc" if exist "%ProgramFiles%\Steam\steamapps\common\MARVEL vs. CAPCOM Fighting Collection\nativeDX11x64\arc\pc\game_50.arc" set MVCPath=%ProgramFiles%\Steam\steamapps\common\MARVEL vs. CAPCOM Fighting Collection\nativeDX11x64\arc\pc
if not exist "%MVCPath%\game_50.arc" if exist "%~dp0..\..\..\..\..\MARVEL vs. CAPCOM Fighting Collection\nativeDX11x64\arc\pc\game_50.arc" set MVCPath=%~dp0..\..\..\..\..\MARVEL vs. CAPCOM Fighting Collection\nativeDX11x64\arc\pc

for /f "tokens=2* skip=1" %%a in ('reg query "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Steam App 2400430" /v InstallLocation 2^>NUL') do set CFC2BasePath=%%b
set CFC2Path=%CFC2BasePath%\nativeDX11x64\arc\pc

if not exist "%CFC2Path%\game_10.arc" if exist "%ProgramFiles(x86)%\Steam\steamapps\common\CAPCOM FIGHTING COLLECTION 2\nativeDX11x64\arc\pc\game_10.arc" set CF2CPath=%ProgramFiles(x86)%\Steam\steamapps\common\CAPCOM FIGHTING COLLECTION 2\nativeDX11x64\arc\pc
if not exist "%CFC2Path%\game_10.arc" if exist "%ProgramFiles%\Steam\steamapps\common\CAPCOM FIGHTING COLLECTION 2\nativeDX11x64\arc\pc\game_10.arc" set CFC2Path=%ProgramFiles%\Steam\steamapps\common\CAPCOM FIGHTING COLLECTION 2\nativeDX11x64\arc\pc
if not exist "%CFC2Path%\game_10.arc" if exist "%~dp0..\..\..\..\..\CAPCOM FIGHTING COLLECTION 2\nativeDX11x64\arc\pc\game_10.arc" set CFC2Path=%~dp0..\..\..\..\..\CAPCOM FIGHTING COLLECTION 2\nativeDX11x64\arc\pc


REM escape so we can handle variable LFN/SFN paths from system or user
if not ^"%1^" == ^"^" goto havearg

if not exist "%CFCPath%\game_50.arc" if not exist "%MVCPath%\game_50.arc" if not exist "%CFC2Path%\game_10.arc" goto errnone
if not exist "%CFCPath%\game_50.arc" echo Capcom Fighting Collection not installed.
if not exist "%CFC2Path%\game_10.arc" echo Capcom Fighting Collection 2 not installed.
if not exist "%MVCPath%\game_50.arc" echo Marvel vs Capcom Collection not installed.

:selcoll

echo Please select which Collection you want to work with:
echo.
if exist "%CFCPath%\game_50.arc" echo   [1] Capcom Fighting Collection
if exist "%MVCPath%\game_50.arc" echo   [2] Marvel vs Capcom Collection
if exist "%CFC2Path%\game_10.arc" echo   [3] Capcom Fighting Collection 2
echo.

choice /c 123
echo.

if "%ERRORLEVEL%" == "1" if exist "%CFCPath%\game_50.arc" goto selcfc
if "%ERRORLEVEL%" == "2" if exist "%MVCPath%\game_50.arc" goto selmvc
if "%ERRORLEVEL%" == "3" if exist "%CFC2Path%\game_10.arc" goto selcfc2

echo Invalid selection.
echo.
goto selcoll

:havearg

pushd "%~dp0"
set ActivePath=
if "%CFCPath%\" == "%~dp1" set ActivePath=%CFCPath%&set ActiveSet=CFC
if "%MVCPath%\" == "%~dp1" set ActivePath=%MVCPath%&set ActiveSet=MVC
if "%CFC2Path%\" == "%~dp1" set ActivePath=%CFC2Path%&set ActiveSet=CFC2
if "%ActivePath%" == "" goto badarg

set User_GameChoice=%~n1

if "%~x1" == ".arc" goto unpack
if "%~x1" == "" goto pack

:badarg

echo We couldn't figure out how to handle this argument.
echo Please try running just the script.
echo.
pause

goto done

:selcfc
set ActivePath=%CFCPath%
set ActiveSet=CFC

echo Please select which language:
echo.
echo   [1] English
echo   [2] Japanese
echo (Note that VH2 and VS2 are Japan-only.)
echo.

choice /c 12
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=1&goto cfcEN
if "%ERRORLEVEL%" == "2" set User_GameChoice=0&goto cfcJPN

:cfcEN

echo   [1] Cyberbots Fullmetal Madness (USA 950424)
echo   [2] Super Puzzle Fighter II Turbo (USA 960620)
echo   [3] Super Gem Fighter Minimix (USA 970904)
echo   [4] Hyper Street Fighter II: The Anniversary Edition (USA 040202)
echo   [5] Red Earth (USA 961121)
echo   [6] Darkstalkers: The Night Warriors (USA 940818)
echo   [7] Night Warriors: Darkstalkers' Revenge (USA 950406)
echo   [8] Vampire Savior: The Lord of Vampire (USA 970519)

choice /c 12345678
echo.

goto makecfc

:cfcJPN

echo   [1] Cyberbots Fullmetal Madness (Japan 950420)
echo   [2] Super Puzzle Fighter II X (Japan 960531)
echo   [3] Pocket Fighter (Japan 970904)
echo   [4] Hyper Street Fighter II: The Anniversary Edition (Japan 040202)
echo   [5] Warzard (Japan 961121)
echo   [6] Vampire: The Night Warriors (Japan 940705)
echo   [7] Vampire Hunter: Darkstalkers' Revenge (Japan 950302)
echo   [8] Vampire Savior: The Lord of Vampire (Japan 970519)
echo   [9] Vampire Hunter 2: Darkstalkers' Revenge (Japan 970929)
echo   [0] Vampire Savior 2: The Lord of Vampire (Japan 970913)

choice /c 1234567890
echo.

goto makecfc

:makecfc
if "%ERRORLEVEL%" == "1" set User_GameChoice=game_5%User_GameChoice%&goto selpath
if "%ERRORLEVEL%" == "2" set User_GameChoice=game_6%User_GameChoice%&goto selpath
if "%ERRORLEVEL%" == "3" set User_GameChoice=game_7%User_GameChoice%&goto selpath
if "%ERRORLEVEL%" == "4" set User_GameChoice=game_8%User_GameChoice%&goto selpath
if "%ERRORLEVEL%" == "5" set User_GameChoice=game_9%User_GameChoice%&goto selpath
if "%ERRORLEVEL%" == "6" set User_GameChoice=game_0%User_GameChoice%&goto selpath
if "%ERRORLEVEL%" == "7" set User_GameChoice=game_1%User_GameChoice%&goto selpath
if "%ERRORLEVEL%" == "8" set User_GameChoice=game_2%User_GameChoice%&goto selpath
if "%ERRORLEVEL%" == "9" set User_GameChoice=game_30&goto selpath
if "%ERRORLEVEL%" == "10" set User_GameChoice=game_40&goto selpath

:selmvc
set ActivePath=%MVCPath%
set ActiveSet=MVC

echo.
echo Please select the game to work with:
echo.
echo   [1] Marvel Super Heroes
echo   [2] Marvel Super Heroes Vs. Street Fighter
echo   [3] Marvel Vs. Capcom: Clash of Super Heroes
echo   [4] Marvel Vs. Capcom 2: New Age of Heroes
echo   [5] The Punisher
echo   [6] X-Men: Children of the Atom
echo   [7] X-Men Vs. Street Fighter
echo.

choice /c 1234567
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=game_1&goto mvclang
if "%ERRORLEVEL%" == "2" set User_GameChoice=game_3&goto mvclang
if "%ERRORLEVEL%" == "3" set User_GameChoice=game_4&goto mvclang
if "%ERRORLEVEL%" == "4" set User_GameChoice=game_5&goto selmvc2
if "%ERRORLEVEL%" == "5" set User_GameChoice=game_6&goto mvclang
if "%ERRORLEVEL%" == "6" set User_GameChoice=game_0&goto mvclang
if "%ERRORLEVEL%" == "7" set User_GameChoice=game_2&goto selxvsf

echo Invalid selection: exiting.

goto done

:mvclang

echo.
echo Please select which language:
echo.
echo   [1] English
echo   [2] Japanese
echo.

choice /c 12
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=%User_GameChoice%1&goto selpath
if "%ERRORLEVEL%" == "2" set User_GameChoice=%User_GameChoice%0&goto selpath

echo Invalid selection: exiting.

goto done

:selmvc2

echo Please select which part:
echo   [1] Game
echo   [2] Sound Effects
echo.

choice /c 12
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=%User_GameChoice%0&goto selpath
if "%ERRORLEVEL%" == "2" set User_GameChoice=%User_GameChoice%s&goto selpath

echo Invalid selection: exiting.

goto done

:selxvsf

echo.
echo Please select which version:
echo.
echo   [1] 961023 English (961023 is used for Ranked)
echo   [2] 961023 Japanese (961023 is used for Ranked) 
echo   [3] 961004 English
echo   [4] 961004 Japanese
echo   [5] 960910 English
echo   [6] 960910 Japanese
echo.

choice /c 123456
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=%User_GameChoice%1&goto selpath
if "%ERRORLEVEL%" == "2" set User_GameChoice=%User_GameChoice%0&goto selpath
if "%ERRORLEVEL%" == "3" set User_GameChoice=%User_GameChoice%3&goto selpath
if "%ERRORLEVEL%" == "4" set User_GameChoice=%User_GameChoice%2&goto selpath
if "%ERRORLEVEL%" == "5" set User_GameChoice=%User_GameChoice%5&goto selpath
if "%ERRORLEVEL%" == "6" set User_GameChoice=%User_GameChoice%4&goto selpath

echo Invalid selection: exiting.

goto done

:selcfc2
set ActivePath=%CFC2Path%
set ActiveSet=CFC2

echo.
echo Please select the game to work with:
echo.
echo   [1] Capcom vs SNK Pro
echo   [2] Capcom vs SNK 2
echo   [3] Capcom Fighting Jam
echo   [4] Street Fighter Zero 3 Upper
echo   [5] Power Stone
echo   [6] Power Stone 2
echo   [7] Project Justice
echo   [8] Star Gladiator 2
echo.

choice /c 12345678
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=game_0&goto selcvs1
if "%ERRORLEVEL%" == "2" set User_GameChoice=game_1&goto selcvs2
if "%ERRORLEVEL%" == "3" set User_GameChoice=game_2&goto selcfj
if "%ERRORLEVEL%" == "4" set User_GameChoice=game_3&goto selz3u
if "%ERRORLEVEL%" == "5" set User_GameChoice=game_4&goto selpws1
if "%ERRORLEVEL%" == "6" set User_GameChoice=game_5&goto selpws2
if "%ERRORLEVEL%" == "7" set User_GameChoice=game_6&goto selmjus
if "%ERRORLEVEL%" == "8" set User_GameChoice=game_7&goto selstg2


echo Invalid selection: exiting.

goto done

:selcvs1

echo Please select which part:
echo   [1] Game
echo   [2] Sound Effects
echo.

choice /c 12
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=%User_GameChoice%0&goto selpath
if "%ERRORLEVEL%" == "2" set User_GameChoice=%User_GameChoice%s&goto selpath

echo Invalid selection: exiting.

goto done

:selcvs2

echo Please select which part:
echo   [1] Game
echo   [2] Sound Effects
echo   [3] 2k25 Sound Effects
echo.

choice /c 123
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=%User_GameChoice%0&goto selpath
if "%ERRORLEVEL%" == "2" set User_GameChoice=%User_GameChoice%s&goto selpath
if "%ERRORLEVEL%" == "3" set User_GameChoice=%User_GameChoice%t&goto selpath

echo Invalid selection: exiting.

goto done

:selcfj

echo Please select which part:
echo   [1] Game
echo   [2] Sound Effects
echo.

choice /c 12
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=%User_GameChoice%0&goto selpath
if "%ERRORLEVEL%" == "2" set User_GameChoice=%User_GameChoice%s&goto selpath

echo Invalid selection: exiting.

goto done

:selz3u

echo Please select which part:
echo   [1] Game (SFA3 Upper)
echo   [2] Sound Effects (non-Max characters)
echo   [3] Game (SFA3 Max)
echo   [4] Sound Effects (Max characters)
echo.

choice /c 1234
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=%User_GameChoice%0&goto selpath
if "%ERRORLEVEL%" == "2" set User_GameChoice=%User_GameChoice%s&goto selpath
if "%ERRORLEVEL%" == "3" set User_GameChoice=%User_GameChoice%2&goto selpath
if "%ERRORLEVEL%" == "4" set User_GameChoice=%User_GameChoice%t&goto selpath

echo Invalid selection: exiting.

goto done

:selpws1

echo Please select which part:
echo   [1] Game
echo   [2] Sound Effects
echo.

choice /c 12
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=%User_GameChoice%0&goto selpath
if "%ERRORLEVEL%" == "2" set User_GameChoice=%User_GameChoice%s&goto selpath

echo Invalid selection: exiting.

goto done

:selpws2

echo Please select which part:
echo   [1] Game
echo   [2] Sound Effects
echo   [3] Sound Effects (August patch)
echo.

choice /c 123
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=%User_GameChoice%0&goto selpath
if "%ERRORLEVEL%" == "2" set User_GameChoice=%User_GameChoice%s&goto selpath
if "%ERRORLEVEL%" == "3" set User_GameChoice=%User_GameChoice%t&goto selpath

echo Invalid selection: exiting.

goto done

:selmjus

echo Please select which part:
echo   [1] Game
echo   [2] Sound Effects
echo   [3] 2K25 Sound Effects
echo.

choice /c 123
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=%User_GameChoice%0&goto selpath
if "%ERRORLEVEL%" == "2" set User_GameChoice=%User_GameChoice%s&goto selpath
if "%ERRORLEVEL%" == "3" set User_GameChoice=%User_GameChoice%t&goto selpath

echo Invalid selection: exiting.

goto done

:selstg2

echo Please select which part:
echo   [1] Star Gladiator 2 (JPN)
echo   [2] Plasma Sword (US)
echo   [3] Sound Effects
echo.

choice /c 123
echo.

if "%ERRORLEVEL%" == "1" set User_GameChoice=%User_GameChoice%0&goto selpath
if "%ERRORLEVEL%" == "2" set User_GameChoice=%User_GameChoice%1&goto selpath
if "%ERRORLEVEL%" == "3" set User_GameChoice=%User_GameChoice%s&goto selpath

echo Invalid selection: exiting.

goto done

:selpath

echo Please select which option:
echo.
echo   [1] Unpack (so you can work with it)
echo   [2] Repack (so game can see it)
echo.

choice /c 12
echo.

if "%ERRORLEVEL%" == "1" goto unpack
if "%ERRORLEVEL%" == "2" goto pack

echo Invalid selection: exiting.

goto done


:unpack

if not exist "arctool.exe" goto error1
if not exist "%ActivePath%\%User_GameChoice%.arc" goto errnone

echo Running: arctool -x -pc -txt -v 7 "%ActivePath%\%User_GameChoice%.arc"
arctool -x -pc -txt -v 7 "%ActivePath%\%User_GameChoice%.arc"

if not "%User_GameChoice%" == "game_5s" if not exist "%ActivePath%\%User_GameChoice%\bin\*%RevExtension%" goto error2

mkdir ".\%ActiveSet%" 2>NUL
mkdir ".\%ActiveSet%\%User_GameChoice%" 2>NUL
move "%ActivePath%\%User_GameChoice%.arc.txt" ".\%ActiveSet%"

if "%User_GameChoice%" == "game_5s" for /f %%a in ('dir /b /a:d "%ActivePath%\%User_GameChoice%"') do xcopy /s /y "%ActivePath%\%User_GameChoice%" ".\%ActiveSet%\%User_GameChoice%"
if not "%User_GameChoice%" == "game_5s" for /f %%a in ('dir /b /a:d "%ActivePath%\%User_GameChoice%"') do mkdir ".\%ActiveSet%\%User_GameChoice%\%%a" 2>NUL
if not "%User_GameChoice%" == "game_5s" for /f %%a in ('dir /b /a:d "%ActivePath%\%User_GameChoice%"') do move "%ActivePath%\%User_GameChoice%\%%a\*" ".\%ActiveSet%\%User_GameChoice%\%%a"
if not "%User_GameChoice%" == "game_5s" for /f %%a in ('dir /b /a:d "%ActivePath%\%User_GameChoice%"') do rmdir "%ActivePath%\%User_GameChoice%\%%a"
if not "%User_GameChoice%" == "game_5s" rmdir "%ActivePath%\%User_GameChoice%" 2>NUL

echo.
if "%User_GameChoice%" == "game_5s" echo The extracted data can now be found at .\%ActiveSet%\%User_GameChoice%\sound
if not "%User_GameChoice%" == "game_5s" echo The extracted game can now be found at .\%ActiveSet%\%User_GameChoice%\bin
echo.

pause
goto done

:pack

if not exist ".\%ActiveSet%\%User_GameChoice%" goto errnounp
if not exist ".\%ActiveSet%\%User_GameChoice%.arc.txt" goto errnotxt
if not exist "arctool.exe" goto error1

cd "%ActiveSet%"
echo Running ..\arctool -c -pc -txt -v 7 %User_GameChoice% in folder %ActiveSet%
..\arctool -c -pc -txt -v 7 %User_GameChoice%

if not exist ".\%User_GameChoice%.arc" cd ..&goto err2unp

move ".\%User_GameChoice%.arc" "%ActivePath%\%User_GameChoice%.arc"

if not exist "%ActivePath%\%User_GameChoice%.arc" cd ..&goto err2unp

echo.
echo Updated file copied to %ActivePath%\%User_GameChoice%.arc
echo.

cd ..

echo.
echo The game has been repacked and should be good to play.  Enjoy!
echo.

pause
goto done

:error1

echo.
echo ArcTool needs to be in the same directory as this BAT file.
echo Please make sure this tool is in the right place and then try again.
echo.

pause
goto done

:error2

echo.
echo ArcTool failed to extract the file.  
echo First, restart.
echo If that doesn't work, reinstall the game and then it should work.
echo.

pause
goto done

:err2unp

echo.
echo ArcTool failed to repack the file.  
echo First, restart.
echo If that doesn't work, reinstall the game and then it should work.
echo.

pause
goto done

:errnone

echo.
echo We couldn't detect any installed collections.
echo Hit up Preppy with system details if you think you do have one of the collections installed.
echo.

pause
goto done

:errnotxt

echo.
echo The required packaging guide ".\%ActiveSet%\%User_GameChoice%.arc.txt" was not found.
echo Please unpack the game again so that we have that critical packaging data.
echo.

pause
goto done

:errnounp

echo An extracted copy of this game was not found.
echo Please make sure you have unpacked the game first.
echo We were looking for the folder ".\%ActiveSet%\%User_GameChoice%" and it was not present.
echo.

pause
goto done

:errsnd

echo.
echo Due to how the sound effect files are packed, please remove your ".\%ActiveSet%\%User_GameChoice%" folder.
echo We will be creating that during the unpack.
echo.

pause
goto done

:done
